/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_2540;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.definition.DefinitionModifierSlots;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.harvest.IHarvestLogic;
import slimeknights.tconstruct.library.tools.definition.module.IToolModule;
import slimeknights.tconstruct.library.tools.definition.weapon.IWeaponAttack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.MultiplierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;

public class ToolDefinitionData {
    @VisibleForTesting
    protected static final Stats EMPTY_STATS = new Stats(StatsNBT.EMPTY, MultiplierNBT.EMPTY);
    public static final ToolDefinitionData EMPTY = new ToolDefinitionData(Collections.emptyList(), EMPTY_STATS, DefinitionModifierSlots.EMPTY, Collections.emptyList(), Collections.emptySet(), null, null, ModifierHookMap.EMPTY);
    @Nullable
    private final List<PartRequirement> parts;
    @Nullable
    private final Stats stats;
    @Nullable
    private final DefinitionModifierSlots slots;
    @Nullable
    private final List<ModifierEntry> traits;
    @Nullable
    @VisibleForTesting
    protected final Set<ToolAction> actions;
    @Nullable
    private final Harvest harvest;
    @Nullable
    private final IWeaponAttack attack;
    @Nullable
    private final ModifierHookMap modules;

    public List<PartRequirement> getParts() {
        return Objects.requireNonNullElse(this.parts, Collections.emptyList());
    }

    protected Stats getStats() {
        return Objects.requireNonNullElse(this.stats, EMPTY_STATS);
    }

    protected DefinitionModifierSlots getSlots() {
        return Objects.requireNonNullElse(this.slots, DefinitionModifierSlots.EMPTY);
    }

    public List<ModifierEntry> getTraits() {
        return Objects.requireNonNullElse(this.traits, Collections.emptyList());
    }

    public boolean canPerformAction(ToolAction action) {
        return this.actions != null && this.actions.contains(action);
    }

    public int getStartingSlots(SlotType type) {
        return this.getSlots().getSlots(type);
    }

    public ModifierHookMap getModules() {
        return Objects.requireNonNullElse(this.modules, ModifierHookMap.EMPTY);
    }

    public <T> T getModule(ModifierHook<T> hook) {
        return this.getModules().getOrDefault(hook);
    }

    public Set<IToolStat<?>> getAllBaseStats() {
        return this.getStats().getBase().getContainedStats();
    }

    public boolean hasBaseStat(IToolStat<?> stat) {
        return this.getStats().getBase().hasStat(stat);
    }

    public <T> T getBaseStat(IToolStat<T> toolStat) {
        return this.getStats().getBase().get(toolStat);
    }

    public float getMultiplier(INumericToolStat<?> toolStat) {
        return this.getStats().getMultipliers().get(toolStat);
    }

    public void buildStatMultipliers(ModifierStatsBuilder builder) {
        if (this.stats != null) {
            MultiplierNBT multipliers = this.stats.getMultipliers();
            for (INumericToolStat<?> stat : multipliers.getContainedStats()) {
                stat.multiplyAll(builder, multipliers.get(stat));
            }
        }
    }

    public void buildSlots(ModDataNBT persistentModData) {
        if (this.slots != null) {
            for (SlotType type : this.slots.containedTypes()) {
                persistentModData.setSlots(type, this.slots.getSlots(type));
            }
        }
    }

    public IHarvestLogic getHarvestLogic() {
        if (this.harvest != null && this.harvest.logic != null) {
            return this.harvest.logic;
        }
        return IHarvestLogic.DEFAULT;
    }

    public IAreaOfEffectIterator getAOE() {
        if (this.harvest != null && this.harvest.aoe != null) {
            return this.harvest.aoe;
        }
        return IAreaOfEffectIterator.DEFAULT;
    }

    public IWeaponAttack getAttack() {
        return Objects.requireNonNullElse(this.attack, IWeaponAttack.DEFAULT);
    }

    public void write(class_2540 buffer) {
        List<PartRequirement> parts = this.getParts();
        buffer.method_10804(parts.size());
        for (PartRequirement part : parts) {
            part.write(buffer);
        }
        Stats stats = this.getStats();
        stats.getBase().toNetwork(buffer);
        stats.getMultipliers().toNetwork(buffer);
        this.getSlots().write(buffer);
        List<ModifierEntry> traits = this.getTraits();
        buffer.method_10804(traits.size());
        for (ModifierEntry entry : traits) {
            entry.write(buffer);
        }
        if (this.actions == null) {
            buffer.method_10804(0);
        } else {
            buffer.method_10804(this.actions.size());
            for (ToolAction action : this.actions) {
                buffer.method_10814(action.name());
            }
        }
        IHarvestLogic.LOADER.toNetwork(this.getHarvestLogic(), buffer);
        IAreaOfEffectIterator.LOADER.toNetwork(this.getAOE(), buffer);
        IWeaponAttack.LOADER.toNetwork(this.getAttack(), buffer);
        IToolModule.write(this.getModules(), buffer);
    }

    public static ToolDefinitionData read(class_2540 buffer) {
        int size = buffer.method_10816();
        ImmutableList.Builder parts = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            parts.add((Object)PartRequirement.read(buffer));
        }
        StatsNBT bonuses = StatsNBT.fromNetwork(buffer);
        MultiplierNBT multipliers = MultiplierNBT.fromNetwork(buffer);
        DefinitionModifierSlots slots = DefinitionModifierSlots.read(buffer);
        size = buffer.method_10816();
        ImmutableList.Builder traits = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            traits.add((Object)ModifierEntry.read(buffer));
        }
        size = buffer.method_10816();
        ImmutableSet.Builder actions = ImmutableSet.builder();
        for (int i = 0; i < size; ++i) {
            actions.add((Object)ToolAction.get((String)buffer.method_19772()));
        }
        IHarvestLogic harvestLogic = IHarvestLogic.LOADER.fromNetwork(buffer);
        IAreaOfEffectIterator aoe = IAreaOfEffectIterator.LOADER.fromNetwork(buffer);
        IWeaponAttack attack = IWeaponAttack.LOADER.fromNetwork(buffer);
        ModifierHookMap modules = IToolModule.read(buffer);
        return new ToolDefinitionData((List<PartRequirement>)parts.build(), new Stats(bonuses, multipliers), slots, (List<ModifierEntry>)traits.build(), (Set<ToolAction>)actions.build(), new Harvest(harvestLogic, aoe), attack, modules);
    }

    protected ToolDefinitionData(@Nullable List<PartRequirement> parts, @Nullable Stats stats, @Nullable DefinitionModifierSlots slots, @Nullable List<ModifierEntry> traits, @Nullable Set<ToolAction> actions, @Nullable Harvest harvest, @Nullable IWeaponAttack attack, @Nullable ModifierHookMap modules) {
        this.parts = parts;
        this.stats = stats;
        this.slots = slots;
        this.traits = traits;
        this.actions = actions;
        this.harvest = harvest;
        this.attack = attack;
        this.modules = modules;
    }

    public static class Stats {
        @Nullable
        private final StatsNBT base;
        @Nullable
        private final MultiplierNBT multipliers;

        public StatsNBT getBase() {
            return Objects.requireNonNullElse(this.base, StatsNBT.EMPTY);
        }

        public MultiplierNBT getMultipliers() {
            return Objects.requireNonNullElse(this.multipliers, MultiplierNBT.EMPTY);
        }

        public Stats(@Nullable StatsNBT base, @Nullable MultiplierNBT multipliers) {
            this.base = base;
            this.multipliers = multipliers;
        }
    }

    protected static class Harvest {
        @Nullable
        private final IHarvestLogic logic;
        @Nullable
        private final IAreaOfEffectIterator aoe;

        public Harvest(@Nullable IHarvestLogic logic, @Nullable IAreaOfEffectIterator aoe) {
            this.logic = logic;
            this.aoe = aoe;
        }

        @Nullable
        public IHarvestLogic getLogic() {
            return this.logic;
        }

        @Nullable
        public IAreaOfEffectIterator getAoe() {
            return this.aoe;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Harvest)) {
                return false;
            }
            Harvest other = (Harvest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IHarvestLogic this$logic = this.getLogic();
            IHarvestLogic other$logic = other.getLogic();
            if (this$logic == null ? other$logic != null : !this$logic.equals(other$logic)) {
                return false;
            }
            IAreaOfEffectIterator this$aoe = this.getAoe();
            IAreaOfEffectIterator other$aoe = other.getAoe();
            return !(this$aoe == null ? other$aoe != null : !this$aoe.equals(other$aoe));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Harvest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IHarvestLogic $logic = this.getLogic();
            result = result * 59 + ($logic == null ? 43 : $logic.hashCode());
            IAreaOfEffectIterator $aoe = this.getAoe();
            result = result * 59 + ($aoe == null ? 43 : $aoe.hashCode());
            return result;
        }

        public String toString() {
            return "ToolDefinitionData.Harvest(logic=" + this.getLogic() + ", aoe=" + this.getAoe() + ")";
        }
    }
}

